---
title: Add a site · Cloudflare Learning Paths
description: In clientless access deployments, users connect to internal
  applications via public hostnames. You will need to own a domain, add it to
  Cloudflare, and configure Cloudflare as the authoritative DNS provider for
  that domain. Enterprise customers who cannot change their authoritative DNS
  provider have the option to configure a partial (CNAME) setup.
lastUpdated: 2025-09-05T20:18:28.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/clientless-access/initial-setup/add-site/
  md: https://developers.cloudflare.com/learning-paths/clientless-access/initial-setup/add-site/index.md
---

In clientless access deployments, users connect to internal applications via public hostnames. You will need to own a domain, add it to Cloudflare, and configure Cloudflare as the [authoritative DNS provider](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#update-your-nameservers) for that domain. Enterprise customers who cannot change their authoritative DNS provider have the option to configure a [partial (`CNAME`) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/).

You only need to add one domain to Cloudflare, since you can create an infinite number of subdomains to manage all of your private applications.

## Add a site to Cloudflare

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login).
2. Select **Onboard a domain**.
3. Enter your website's apex domain (`example.com`).
4. Select a [plan](https://www.cloudflare.com/plans/#compare-features) for this website. Everything you need to do with the domain in Cloudflare Zero Trust is available on the **Free** plan.
5. Select **Continue**. Cloudflare will scan your website for any configured DNS records.

Note

If Cloudflare is unable to identify your domain as a registered domain, make sure you are using an existing [top-level domain](https://www.cloudflare.com/learning/dns/top-level-domain/) (`.com`, `.net`, `.biz`, or others).

Additionally, Cloudflare requires your `apex domain` to be one level below a valid TLD defined in the [Public Suffix List (PSL)](https://github.com/publicsuffix/list/blob/master/public_suffix_list.dat).

1. Review your DNS records and select **Continue**.

2. Before your domain can begin using Cloudflare for DNS resolution, you need to [add these nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#update-your-nameservers) at your registrar. DNSSEC should still be **disabled** at this point.

   If you cannot [change your domain nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/), you can still use Cloudflare on your website by activating Cloudflare through a [certified hosting partner](https://www.cloudflare.com/hosting-partners) using a [partial (CNAME) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/).

3. (Optional) Follow the **Quick Start Guide** to configure security and performance settings.

Registrars can take up to 24 hours to process nameserver changes. Your domain must be in an **Active** status before you can use it for clientless access.
