---
title: Components · Cloudflare Style Guide
description: When you are contributing to the Cloudflare Docs, you can use our
  custom components to add additional formatting, such as buttons, tabs, and
  collapsible sections.
lastUpdated: 2025-10-27T14:04:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/
  md: https://developers.cloudflare.com/style-guide/components/index.md
---

When you are [contributing to the Cloudflare Docs](https://developers.cloudflare.com/style-guide/contributions/), you can use our custom components to add additional formatting, such as buttons, tabs, and collapsible sections.

This guide shows you the basics of importing and adding a component to a page. Refer to each component page in this Style Guide to learn the specific props and requirements for each.

Our components are based on [Astro components](https://docs.astro.build/en/basics/astro-components/) and are written in [MDX](https://docs.astro.build/en/guides/markdown-content/), an extended version of Markdown. [Learn more about the Cloudflare Docs framework](https://developers.cloudflare.com/style-guide/how-we-docs/our-site/#site-framework).

## Add a component to a page

To add a component to a page:

1. Import the component to the page by adding this text directly below the [frontmatter](https://developers.cloudflare.com/style-guide/frontmatter/):

   ```mdx
   import { COMPONENT_NAME } from "~/components";
   ```

   For example, if you were to add [the `DashButton` component](https://developers.cloudflare.com/style-guide/components/dash-button/) to the [Images getting started page](https://developers.cloudflare.com/images/get-started/), the top of the MDX file corresponding to that page would look like the following:

   ```mdx
   ---
   pcx_content_type: get-started
   title: Getting started
   sidebar:
     order: 2


   ---


   import { DashButton } from "~/components";
   ```

2. Add the component to the page by adding this text anywhere on the page you want the component to appear:

   ```mdx
     <COMPONENT_NAME PROP_NAME="PROP_VALUE" />
   ```

   For example, if you were to add the `DashButton` component to some steps in the [Images getting started page](https://developers.cloudflare.com/images/get-started/), here is how the MDX file would look:

   ```mdx
   1. In the Cloudflare dashboard, go to the **Transformations** page.


    <DashButton url="/?to=/:account/images/delivery-zones" />


   2. Go to the specific zone where you want to enable transformations.
   ```

This is how this example would display after it is published:

![DashButton component example](https://developers.cloudflare.com/_astro/dashbutton-example.Dr0ifkyr_1pzXhV.webp)
