---
title: TypeScript example · Cloudflare Style Guide
description: The TypeScriptExample component uses ts-blank-space to remove
  TypeScript-specific syntax from your example and provide a JavaScript tab.
  This reduces maintenance burden by only having a single example to maintain.
lastUpdated: 2025-03-31T14:03:09.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/typescript-example/
  md: https://developers.cloudflare.com/style-guide/components/typescript-example/index.md
---

## TypeScript examples

The `TypeScriptExample` component uses [`ts-blank-space`](https://github.com/bloomberg/ts-blank-space) to remove TypeScript-specific syntax from your example and provide a JavaScript tab. This reduces maintenance burden by only having a single example to maintain.

This component is automatically used in the [`GitHubCode`](https://developers.cloudflare.com/style-guide/components/github-code/) component when the `lang` is set to `ts`.

Note

Some TypeScript syntax influences runtime behaviour, and cannot be stripped.

Please refer to the [Unsupported Syntax](https://github.com/bloomberg/ts-blank-space?tab=readme-ov-file#unsupported-syntax) section of the project's README.

Warning

Code blocks are typically configured with options on the opening fence, like so:

````mdx
```ts collapse={1-2}
// ...
```
````

These cannot be extracted by `TypeScriptExample` so they must be moved to the [`code`](#code) prop.

````mdx
<TypeScriptExample code={{
  collapse: "1-2"
}}>
```ts
// ...
```
</TypeScriptExample>
````

## Component

## `<TypeScriptExample>` Props

### `filename`

**type:** `string`

An optional filename, ending in `.ts`.

`.ts` will be replaced by `.js` for the JavaScript tab.

### `playground`

**type:** `boolean`

If set to `true`, a [`Run Worker in Playground`](https://developers.cloudflare.com/style-guide/components/code/#playground) button will appear on the JavaScript tab.

### `code`

**type**: `object`

Props to pass to the [Expressive Code component](https://expressive-code.com/key-features/code-component/).

These props will apply to both code blocks and so options like `collapse` may not work as expected, as lines may be removed from the TypeScript code.
