---
title: Return small HTML page · Cloudflare Workers docs
description: Deliver an HTML page from an HTML string directly inside the Worker script.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python,Rust
source_url:
  html: https://developers.cloudflare.com/workers/examples/return-html/
  md: https://developers.cloudflare.com/workers/examples/return-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/return-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwA2AOwAmYQA5J4gMwBOQQC4WLNsA5wuNPgJETpsxYICwAKADC6KhACmt7ABEoAZxjpXUaDeUkNeATEJFRwwHYMAERQNHYAHgB0AFaukaSoUGAOYRHRsYkpkRbWtg4Q2AAqdDB2fnAwMGB8BFA2yElwAG5wrrwIsBAA1MDouOB2FhbxHkgkuHaocOAQJADe5iQkPXRUvP52ELwAFgAUCHYAjiB2rhAAlGsbmyS8NrckRxDAYCQMJAAGAB4AIROADylgqAE0AAoAUQ+XzAAD4nptARRcHRUc9noCjgBGZEACTsYDA6BIAHVMGBcIDkIScbiSICYMiKkc3CRgIgANYgGAkADuPRIAHMHHYEAQ7LhyHQtiRLBSQLhUGBEHZqZg+dKEgz2WjWchMdj-kRzMbzhAQAgqCE7MKSAAlG4eKiuOwnT7fAA0jxZHzscHmCFcfnWQc2kVepUcEGqdkifki9jiKF9YCIx0QXogDAAqhUAGLYKSRP3GzYAXyruJrd0ttarNaIFjUzA0Wh0PH4QjEkhkwnkSmKNnsjhc7k83laVD8AS0pFC4Si4UIWjS-ky2TXkTIFLIRSsE7KlSTdQaTV4LTaKRsk3Mq0ivJiAH0RmMsim8vMCqkNYdp23ZBL2egDoYw6joIzAWEAA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          html = """<!DOCTYPE html>
          <body>
            <h1>Hello World</h1>
            <p>This markup was generated by a Cloudflare Worker.</p>
          </body>"""


          headers = {"content-type": "text/html;charset=UTF-8"}
          return Response(html, headers=headers)
  ```

* Rust

  ```rs
  use worker::*;


  #[event(fetch)]
  async fn fetch(_req: Request, _env: Env, _ctx: Context) -> Result<Response> {
      let html = r#"<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>
      "#;
      Response::from_html(html)
  }
  ```

* Hono

  ```ts
  import { Hono } from "hono";
  import { html } from "hono/html";


  const app = new Hono();


  app.get("*", (c) => {
    const doc = html`<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker with Hono.</p>
      </body>`;


    return c.html(doc);
  });


  export default app;
  ```
